
/**
 * OA login shortcode
 */

 function oaDisplayLoginQR(cartData) {

    const containers = document.querySelectorAll(".OpenAppCheckoutLogin");
    containers.forEach(container => {
        container.setAttribute("data-merchantId", cartData.psdata.merchant_id);
        container.setAttribute("data-integrationProfileId", cartData.psdata.profile_id);
        container.setAttribute("data-token", cartData.psdata.cart_id);
        // console.log(container.getAttribute('data-lang') );

        if( container.getAttribute('data-lang') === '') {
            container.setAttribute("data-lang", cartData.psdata.lang);
        }
        
        container.classList.remove("isErrorOA");
        container.classList.remove("OpenAppCheckout-loading");
        container.classList.add("OpenAppCheckout");

        const OAEvent = new CustomEvent("OpenAppCheckout", {
            detail: {},
            bubbles: true,
            cancelable: true,
            composed: false,
        });

        container.dispatchEvent(OAEvent);
    });
}
function oaDisplayQaCodeError2(textMessage){
    const containers = document.querySelectorAll(".OpenAppCheckoutLogin");
    containers.forEach(container => {
        container.classList.add("isErrorOA");
        container.innerHTML = textMessage;
    });
}
(function ($) {
    $(document).ready(function($) {

        let oaLogin = document.querySelectorAll (".OpenAppCheckoutLogin");

        if( oaLogin.length > 0 ) 
        {
            let cartId = openappVars2_cartId;
            let nonce = openappVars2_nonce;
            const errorTextMessage = openappVars2_errorTextMessage;
            
            let langCode = prestashop.language.language_code;
            let currencyCode = prestashop.currency.iso_code;

            let fetchQrCode2 = function() {
                $.ajax({
                    url: "/openapp/qr_code",
                    method: "GET",
                    data: {
                        cart_id: cartId,
                        lang: langCode
                    },
                    beforeSend: function(xhr) {
                        xhr.setRequestHeader("X-PS-Internal", "true");
                        // xhr.setRequestHeader("X-WP-Nonce", nonce);
                    },
                    success: function(response) {
                        // console.log('qr_login', response);
                        if( response.psdata !== undefined ) {
                            response.psdata.lang = langCode;
                            response.psdata.currency = currencyCode;
                        }
                        if( response.psdata !== undefined) {
                            oaDisplayLoginQR(response);
                        } else {
                            oaDisplayQaCodeError2(response.message);
                        }
                    },
                    error: function(error) {
                        // console.log("Failed to update QR code: ", error);
                        oaDisplayQaCodeError2(errorTextMessage);
                    }
                });


            };

            window.prestashop.on('updatedCart', fetchQrCode2);

            // if there are products on the cart
            if( cartId )
            {
                fetchQrCode2();

                setInterval(function () {
                    $.ajax({
                        url: "/openapp/oa_login",
                        method: "GET",
                        data: {
                            cart_id: cartId,
                        },
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader("X-PS-Internal", "true");
                        },
                        success: function (response) {
                            console.log( response );

                            if (response.should_login) {
                                setTimeout(function() {
                                    window.location.href = response.redirect_url;
                                },1000)
                            }
                        }
                    });
                }, 5000);
            }
        }
        
    });
})(jQuery);